<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('appointments', function (Blueprint $table) {
            $table->id();
            $table->foreignId('patient_id')->constrained()->onDelete('cascade');
            $table->foreignId('doctor_id')->nullable()->constrained()->onDelete('set null');
            $table->foreignId('pharmacist_id')->constrained()->onDelete('cascade');
            $table->foreignId('branch_id')->constrained()->onDelete('cascade');
            $table->enum('consultation_type', [
                'Diagnostic Consultation',
                'Remote Consultation',
                'Primary care Consultation',
                'Mental health support',
                'Psychoanalytic or Psychodynamic Therapy'
            ]);
            $table->enum('appointment_type', ['immediate', 'scheduled'])->default('scheduled');
            $table->datetime('appointment_date')->nullable();
            $table->enum('status', ['pending', 'confirmed', 'in_progress', 'completed', 'cancelled'])->default('pending');
            $table->string('video_call_room_id')->nullable();
            $table->text('additional_medical_notes')->nullable();
            $table->string('pharmacist_signature')->nullable();
            $table->string('client_signature')->nullable();
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('appointments');
    }
};

